	% Multirate_IIR
	close all
	clear all
	clc
	wcT = 0.1*pi; wsT = 0.2*pi;
	L = 3; 
	Nnum = 12;  Nden = 6;
	Dratio = 12; % Dratio = ds/dc 
	wT = linspace(0,pi,1000);  DwT = linspace(0,L*pi,1000); 	
	[Num, Den, dc, ds] = MR_LP_IIR(Nnum, Nden, wcT, wsT, Dratio, L)	
	H0 = freqz(Num,1,wT).*freqz(1, Den, DwT); % N(z)/D(z^L)
	subplot(2,1,1)
	PLOT_MAG_Z_dB(wT, H0, pi, 100, '-'), zoom on
	figure(2)
	Z = roots(Num)
	P = roots(UP_SAMPLE(Den, L));
	PLOT_PZ_Z(Z, P)
	roots(Den)
	
